% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importWQP.R
\name{parse_WQP}
\alias{parse_WQP}
\title{Convert WQP columns to correct types}
\usage{
parse_WQP(retval, tz = "UTC")
}
\arguments{
\item{retval}{Data frame from WQP}

\item{tz}{character to set timezone attribute of datetime. Default is UTC
(properly accounting for daylight savings times based on the associated "TimeZone" column).
Possible values include "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua",
"America/Phoenix", and "America/Metlakatla"}
}
\value{
data frame retval with converted columns
}
\description{
Takes the character results and converts to numeric and dates.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}
# These examples require an internet connection to run
rawSampleURL <- constructWQPURL("USGS-01594440", "01075", "", "")

## Examples take longer than 5 seconds:

\donttest{

rawSample <- importWQP(rawSampleURL, convertType = FALSE)
convertedSample <- parse_WQP(rawSample)

} 
\dontshow{\}) # examplesIf}
}
