% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_groupedbar.R
\name{plot_groupedbar}
\alias{plot_groupedbar}
\title{Plot grouped bar}
\usage{
plot_groupedbar(data, label_x = "", label_y = "", colors = NULL, alpha = 1)
}
\arguments{
\item{data}{data.frame with category in first column and series in remaining columns}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional vector of fill colors, one per series}

\item{alpha}{bar transparency (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Grouped (side‑by‑side) bar chart for multiple series per category.
}
\details{
Expects a data.frame where the first column is the category (x) and the remaining columns are
numeric series. Bars are grouped by series. Provide \code{colors} with length equal to the number of series to set fills.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length), Sepal.Width=mean(Sepal.Width))
head(data)

#ploting data
grf <- plot_groupedbar(data, colors=c("blue", "red"))
plot(grf)
}
