% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_gmm.R
\name{cluster_gmm}
\alias{cluster_gmm}
\title{Gaussian mixture model clustering (GMM)}
\usage{
cluster_gmm(G = NULL, modelNames = NULL)
}
\arguments{
\item{G}{number of mixture components (clusters). If NULL, \code{Mclust} chooses.}

\item{modelNames}{optional character vector of model names passed to \code{Mclust}.}
}
\value{
returns a GMM clustering object.
}
\description{
Model-based clustering using \code{mclust::Mclust}.
}
\details{
Fits a Gaussian mixture model and returns the MAP classification.
The fitted model is stored in \code{obj$model}. Requires the \code{mclust} package.
}
\examples{
data(iris)
model <- cluster_gmm(G = 3)
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)
}
\references{
Fraley, C., & Raftery, A. E. (2002). Model-based clustering. \emph{JASA}.
}
