% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpPrep.R
\name{fpPrep}
\alias{fpPrep}
\title{Process netCDF4 Gridded Data into Format of the fingerprint() Function}
\usage{
fpPrep(
  datafile,
  variable,
  region = "GL",
  target.year,
  average = 5,
  reference = c(1961, 1990),
  regridding = NULL
)
}
\arguments{
\item{datafile}{path to the netCDF4 gridded datafile to be processed}

\item{variable}{the climate variable to be extracted}

\item{region}{the longitude and latitude boundary for selected region, 
should match the format of IPCC AR6 regions, the lon and lat of the vertices}

\item{target.year}{vector of length 2, the starting and ending year of the 
selected time period for D&A analysis}

\item{average}{number of years for average on each gridbox, default is 5-year average}

\item{reference}{vector of length 2, the starting and ending year of reference 
time period for computing anomalies}

\item{regridding}{whether the grid box should be regridded. Specify the size of 
the grid box, e.g., c(40, 30) for \eqn{40^\circ \times 30^\circ} grid box.
If no regridding, leave empty}
}
\value{
a dataset of the processed gridded climate variables for Y, 
  Xtilde or control runs
}
\description{
This function detects the signal factors on the observed data via total 
least square linear regression model.
}
\author{
Yan Li
}
\keyword{NetCDF}
\keyword{fingerprinting}
