% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvsem.R
\name{cvsem}
\alias{cvsem}
\title{Cross-Validation of Structural Equation Models}
\usage{
cvsem(
  data = NULL,
  Models,
  discrepancyMetric = "KL-Divergence",
  k = 5,
  lavaanFunction = "sem",
  echo = TRUE,
  ...
)
}
\arguments{
\item{data}{Data}

\item{Models}{A collection of models, specified in lavaan syntax. Provide Models with the \code{cvgather()} function.}

\item{discrepancyMetric}{Specify which discrepancy metric to use (one of 'KL-Divergence', 'FD', 'GLS'). Default is KL Divergence.}

\item{k}{The number of folds. Default is 5.}

\item{lavaanFunction}{Specify which lavaan function to use. Default is "sem". Other options are "lavaan" and "cfa"}

\item{echo}{Provide feedback on progress to user, defaults to \code{TRUE}. Set to \code{FALSE} to suppress.}

\item{...}{Not used}
}
\value{
A list with the prediction error for each model.
}
\description{
Do model comparison on SEM models using cross-validation as described
in \insertCite{Cudeck1983}{cvsem} and  \insertCite{BrowneCudeck1992}{cvsem}.
Cross-validation is based on the discrepancy between the sample covariance matrix and
the model implied matrix. Currently, \code{cvsem} supports 'KL-Divergence', Frobenius Distance
and Generalized Least Squares 'GLS' as discrepancy metrics.
}
\examples{

example_data <- lavaan::HolzingerSwineford1939
colnames(example_data) <- c("id", "sex", "ageyr", "agemo", 'school', "grade",
"visualPerception", "cubes", "lozenges", "comprehension",
"sentenceCompletion", "wordMeaning", "speededAddition",
"speededCounting", "speededDiscrimination")

model1 <- 'comprehension ~ meaning

           ## Add some latent variables:
        meaning =~ wordMeaning + sentenceCompletion
        speed =~ speededAddition + speededDiscrimination + speededCounting
        speed ~~ meaning'

model2 <- 'comprehension ~ wordMeaning + speededAddition'
model3 <- 'comprehension ~ wordMeaning + speededAddition'

models <- cvgather(model1, model2, model3)

fit <- cvsem( data = example_data, Models = models, k = 10, discrepancyMetric = "KL-Divergence")

}
\references{
\insertAllCited()
}
