% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-int.R
\name{write_uint8}
\alias{write_uint8}
\alias{write_int8}
\alias{write_uint16}
\alias{write_int16}
\alias{write_uint32}
\alias{write_int32}
\alias{write_uint64}
\alias{write_int64}
\title{Convert values to the given type and write to a connection}
\usage{
write_uint8(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_int8(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_uint16(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_int16(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_uint32(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_int32(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_uint64(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)

write_int64(con, x, endian = NULL, bounds_check = NULL, na_check = NULL)
}
\arguments{
\item{con}{Connection object or raw vector. When con is a raw vector, new
data will be \emph{appended} to the vector and returned.
Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{x}{vector to write}

\item{endian}{Ordering of bytes within the file when reading multi-byte values.
Possible values: 'big' or 'little'.  
Default: NULL indicates that
endian option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_endian}()}) or otherwise 
will be set to \code{"little"}}

\item{bounds_check}{Check values lie within bounds of the given type.
Default: NULL indicates that
this option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_bounds_check}()}) or otherwise 
will be set to \code{"error"}}

\item{na_check}{Check for NAs in the data to be written.
Default: NULL indicates that
this option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_na_check}()}) or otherwise 
will be set to \code{"error"}}
}
\value{
If \code{con} is a connection then this connection is returned invisibly.
        If \code{con} is a raw vector then new data is appended to this vector
}
\description{
Convert values to the given type and write to a connection
}
\examples{
con <- file(tempfile(), "wb")
write_uint8(con, 1:4)
close(con)
}
\seealso{
Other data output functions: 
\code{\link{fprintf}()},
\code{\link{write_f64}()},
\code{\link{write_hex}()},
\code{\link{write_raw}()},
\code{\link{write_utf8}()}
}
\concept{data output functions}
