% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingMTDdistribution-class}
\alias{StoppingMTDdistribution-class}
\alias{.StoppingMTDdistribution}
\alias{StoppingMTDdistribution}
\alias{.DefaultStoppingMTDdistribution}
\title{\code{StoppingMTDdistribution}}
\usage{
StoppingMTDdistribution(
  target = 0.33,
  thresh = 0.5,
  prob = 0.9,
  report_label = NA_character_
)

.DefaultStoppingMTDdistribution()
}
\arguments{
\item{target}{(\code{proportion})\cr see slot definition.}

\item{thresh}{(\code{proportion})\cr see slot definition.}

\item{prob}{(\code{proportion})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingMTDdistribution}} is the class for stopping based on the posterior
distribution of the MTD. It is used for the cases where the stopping occurs
when the probability of \code{MTD > thresh * next_dose} is greater than or equal
to \code{prob}, where the \code{next_dose} is the recommended next best dose.
Here, the MTD is defined as the dose that reaches a specific \code{target}
probability of the occurrence of a DLT.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{proportion})\cr the target toxicity probability (except 0 or 1)
defining the MTD.}

\item{\code{thresh}}{(\code{proportion})\cr the threshold (except 0 or 1) relative to the
recommended next best dose.}

\item{\code{prob}}{(\code{proportion})\cr required minimum probability, except 0 or 1.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingMTDDistribution()} function.
}
\examples{
# As example, here is the rule for stopping the study if there is at least 0.9
# probability that MTD > 0.5 * next_dose. Here MTD is defined as the dose for
# which prob(DLT) = 0.33
my_stopping <- StoppingMTDdistribution(
  target = 0.33,
  thresh = 0.5,
  prob = 0.9
)
}
