% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{irr_partition}
\alias{irr_partition}
\title{IRR decomposition between operations and resale}
\usage{
irr_partition(cashflows, tv_disc = NULL, irr_total, initial_investment = NULL)
}
\arguments{
\item{cashflows}{data.frame. Must contain at least
\code{year}, \code{free_cash_flow}, \code{discount_factor}.
If \code{sale_proceeds} is missing, it is assumed to be zero.}

\item{tv_disc}{numeric(1). Terminal value already discounted (net sale),
if available. If \code{NULL}, it is derived from \code{sale_proceeds}
and \code{discount_factor}.}

\item{irr_total}{numeric(1). Total IRR (project or equity) for which the
decomposition is sought (e.g. \code{dcf_res$irr_project} or an equity IRR).}

\item{initial_investment}{numeric(1). Not used here (kept for API compatibility).}
}
\value{
\code{tibble(component, share, irr_contrib)} with two rows:
"Operations" and "Resale".
}
\description{
Approximates the relative contribution of:
\itemize{
\item operational cash flows (acquisition + NOI - capex - opex),
\item resale (net sale in year N),
to the total IRR, using NPV shares (\code{share}) and mapping them to
\code{irr_total} (\code{irr_contrib = irr_total * share}).
}
}
