% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_roche_subgroups.R
\name{tbl_roche_subgroups}
\alias{tbl_roche_subgroups}
\title{Subgroup Analyses}
\usage{
tbl_roche_subgroups(data, rsp, by, subgroups, .tbl_fun)
}
\arguments{
\item{data}{(\code{data.frame}, \code{survey.design})\cr
a data frame or survey object}

\item{rsp}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable to use in responder rate calculations.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable to make comparison between groups.}

\item{subgroups}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to perform stratified analyses for.}

\item{.tbl_fun}{(\code{function})
A function or formula. If a \emph{function}, it is used as is.
If a formula, e.g. \code{~ .x \%>\% tbl_summary() \%>\% add_p()}, it is converted to a function.
The stratified data frame is passed to this function.}
}
\value{
a 'gtsummary' table
}
\description{
Function adapted from \code{gtforester::tbl_subgroups()}.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) withAutoprint(\{ # examplesIf}
tbl <-
  trial |>
  tbl_roche_subgroups(
    rsp = "response",
    by = "trt",
    subgroups = c("grade", "stage"),
    .tbl_fun =
      ~ glm(response ~ trt, data = .x) |>
        tbl_regression(
          show_single_row = trt,
          exponentiate = TRUE
        )
  )

tbl
\dontshow{\}) # examplesIf}
}
