% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_Bayesian.R
\name{init_lm_gprior}
\alias{init_lm_gprior}
\title{Initialize linear regression parameters assuming a g-prior}
\usage{
init_lm_gprior(y, X, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{X_test}{\code{n0 x p} matrix of predictors at test points (default is NULL)}
}
\value{
a named list \code{params} containing at least
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}
Additionally, if X_test is not NULL, then the list includes an element
\code{mu_test}, the vector of conditional means at the test points
}
\description{
Initialize the parameters for a linear regression model assuming a
g-prior for the coefficients.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta}: the \code{p x 1} vector of regression coefficients
components of \code{beta}
}
}
\examples{
# Simulate data for illustration:
sim_dat = simulate_nb_lm(n = 100, p = 5)
y = sim_dat$y; X = sim_dat$X

# Initialize:
params = init_lm_gprior(y = y, X = X)
names(params)
names(params$coefficients)

}
