% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurface.R
\name{getSurface}
\alias{getSurface}
\title{Remove artificial surface layers from processed CT data}
\usage{
getSurface(x, material = "particulates", threshold = 0.40, 
start = "top", thickness = 0.625)
}
\arguments{
\item{x}{dataframe created by \code{conv}}

\item{material}{material used for determining where the surface begins}

\item{threshold}{decimal fraction of total area, used to determine the surface layer. Surface slices where \code{material} exceeds threshold value are removed.}

\item{start}{should core be processed from the top, bottom, or both?}

\item{thickness}{CT image thickness (mm)}
}
\value{
value \code{getSurface} shortens the output of \code{conv} to remove artificial surface layers. The output is thus a subset of the input, and identical in structure to the /code{conv} output.
}
\description{
Identifies and removes artificial surface layers from processed CT data
}
\details{
Identifies and removes artificial surface layers from processed CT data. Areas can be removed from one or both ends of the core (set by \code{start}), based on exceeding a \code{threshold} proportion of material (e.g., 75% particles, sand, etc.)
}
\examples{
### Not run:
\dontrun{data(core_426)
ct.slope <- unique(extractHeader(core_426$hdr, "RescaleSlope"))
ct.int   <- unique(extractHeader(core_426$hdr, "RescaleIntercept")) 
# convert raw units to Hounsfield units
HU_426 <- lapply(core_426$img, function(x) x*ct.slope + ct.int)

materials <- conv(HU_426)
head(materials[, 1:6], 20)

materials2 <- getSurface(materials)
head(materials2[, 1:6])
}
}
\seealso{
\code{\link{conv}}
}
