% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{cor_sim_seq}
\alias{cor_sim_seq}
\title{Calculate Correlation Between Similarity Measures for a Single Dyad}
\usage{
cor_sim_seq(similarities, method = "pearson")
}
\arguments{
\item{similarities}{A list of similarity measures for a single dyad}

\item{method}{The correlation method to use (default is "pearson")}
}
\value{
A correlation matrix
}
\description{
Calculate Correlation Between Similarity Measures for a Single Dyad
}
\details{
This function calculates the correlation between different similarity measures for a single dyad.
}
\examples{
sim1 <- list(sequence = c(0.8, 0.7, 0.9), average = 0.8)
sim2 <- list(sequence = c(0.6, 0.8, 0.7), average = 0.7)
cor_sim_seq(list(sim1, sim2))
print(plot)
}
