% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/dbi_methods.R,
%   R/fs_methods.R, R/logger_generics.R
\name{list_content_cnt}
\alias{list_content_cnt}
\alias{list_content_cnt.ConnectorDBI}
\alias{list_content_cnt.ConnectorFS}
\alias{list_content_cnt.ConnectorLogger}
\title{List available content from the connector}
\usage{
list_content_cnt(connector_object, ...)

\method{list_content_cnt}{ConnectorDBI}(connector_object, ...)

\method{list_content_cnt}{ConnectorFS}(connector_object, ...)

\method{list_content_cnt}{ConnectorLogger}(connector_object, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
A \link{character} vector of content names
}
\description{
Generic implementing of how to list all content available for different connectors:

\itemize{
\item \link{ConnectorDBI}: Uses \code{\link[DBI:dbListTables]{DBI::dbListTables()}} to list the tables in a DBI connection.
}

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[=list.files]{list.files()}} to list all files at the path of the connector.
}

\itemize{
\item \link{ConnectorLogger}: Logs the list operation and calls the underlying connector method.
}
}
\examples{
# List tables in a DBI database
cnt <- connector_dbi(RSQLite::SQLite())

cnt |>
  list_content_cnt()

# List content in a file storage
folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connector_fs(folder)

cnt |>
  list_content_cnt()

#' # Write a file to the file storage
cnt |>
  write_cnt(iris, "iris.csv")

# Only list CSV files using the pattern argument of list.files

cnt |>
  list_content_cnt(pattern = "\\\\.csv$")

# Add logging to a connector and list contents
folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connectors(data = connector_fs(folder)) |> add_logs()

cnt$data |>
  write_cnt(iris, "iris.csv")

cnt$data |>
  list_content_cnt()

}
