% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_cache.R
\name{clean_cache}
\alias{clean_cache}
\title{Clean Conda Cache}
\usage{
clean_cache(verbose = c("output", "silent", "cmd", "spinner", "full"))
}
\arguments{
\item{verbose}{A character string indicating the verbosity level of the
output. It can be one of "silent", "cmd", "output", or "full".
The default is "output".}
}
\value{
Invisibly returns the result of the underlying command executed.
}
\description{
This function cleans the Conda cache by removing all packages and tarballs
from the local cache directory. It is useful for freeing up disk space
and ensuring that the cache does not contain outdated or unnecessary files.
}
\details{
Packages that are still linked with existing environments are not be
removed. If you expect to clean the whole cache, consider removing
all existing environments first using \code{list_envs()} and \code{remove_env()}.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  clean_cache(verbose = "output")
})
}

}
