% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_aln.R
\name{write_aln}
\alias{write_aln}
\alias{write_fasta}
\alias{write_nexus}
\alias{write_phylip}
\title{Writing alignments}
\usage{
write_fasta(x, path)

write_nexus(x, path)

write_phylip(x, path)
}
\arguments{
\item{x}{Alignment to save (an object of class \code{DNAbin}).}

\item{path}{Path of the file to be written, without file extension (the
appropriate extension is added automatically, i.e. the path will be
extended with ".fasta", ".nexus", or ".phy" depending on the file format
used).}
}
\value{
The input \code{x} (invisibly).
}
\description{
Alignments can be saved in \code{fasta}, \code{nexus}, and \code{phylip} formats.
}
\examples{
\dontrun{
  # Path to an example alignment file
  pkg_aln <- concatipede_example("COI_Macrobiotidae.fas")
  # Load the alignment into the R session
  aln <- ape::read.FASTA(pkg_aln)
  # Write the alignment in various formats
  # Note that the appropriate file extension is added by the writing functions.
  write_fasta(aln, "my-alignment")
  write_nexus(aln, "my-alignment")
  write_phylip(aln, "my-alignment")
}
}
