% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{penalty_l1}
\alias{penalty_l1}
\title{L1 penalty function (LASSO)}
\usage{
penalty_l1(weights = NULL)
}
\arguments{
\item{weights}{Optional parameter weights (default: all 1)}
}
\value{
Penalty function
}
\description{
Creates a penalty function that computes the L1 norm (sum of absolute values).
Used for sparsity-inducing regularization.
}
\examples{
penalty <- penalty_l1()
penalty(c(1, -2, 3))  # Returns 6

# Weighted L1
penalty <- penalty_l1(weights = c(1, 2, 1))
penalty(c(1, -2, 3))  # Returns 1*1 + 2*2 + 1*3 = 8
}
