% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{cnd_create_registry}
\alias{cnd_create_registry}
\title{Create a registration}
\usage{
cnd_create_registry(
  registry = get_package(),
  overwrite = FALSE,
  name = ".__CND_REGISTRY__.",
  env = parent.frame()
)
}
\arguments{
\item{registry}{The name of the registry}

\item{overwrite}{When \code{TRUE} will overwrite}

\item{name}{The name of the registry variable.  Default is intended to
prevent potential conflicts with other objects.}

\item{env}{The environment to assign the registry to}
}
\value{
a \code{cnd:registry} object, invisibly
}
\description{
This function will create a new object with the name as \code{name}
in the environment where it is called.  This is intended to be your package
environment, but could potentially be anywhere you want.  If an object which
is not a \code{cnd:registry} object is found with the same name, an error will be
thrown.
}
\details{
Crate a new \code{cnd:registry} to the current environment
}
\examples{
# In most cases, just having the function in your R/ scripts is good enough,
# and you can use `cnd_create_registry()` with its defaults.  The following
# examples are for demonstration purposes:
e <- new.env()
cnd_create_registry("EXAMPLE", env = e)
cnd_create_registry("EXAMPLE", overwrite = TRUE)

}
