% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{allpair_RandIndex}
\alias{allpair_RandIndex}
\title{allpair_RandIndex: helper for replicated cluster comparison}
\usage{
allpair_RandIndex(results)
}
\arguments{
\item{results}{A list with each element packed internally by the
\code{\link{clustra_rand}} function with elements:
\itemize{
\item \code{k} - number of clusters
\item \code{rep} - replicate number
\item \code{deviance} - final deviance
\item \code{group} - integer cluster assignments
Note that item order is assumed to be the same across all \code{rep} and \code{k} but
\code{group} numbering need not be same. The algorithm only examines if pairs of
items are in same or different clusters within each \code{results} list element.
}}
}
\value{
A data frame with \code{\link[MixSim]{RandIndex}} for all pairs from
trajectories results. The data frame names and its format is intended to be
the input for \code{\link{rand_plot}}. Note that all pairs is the lower
triangle plus diagonal of an all-pairs symmetric matrix.
}
\description{
Runs \code{\link[MixSim]{RandIndex}} for all pairs of cluster results in its
list input and produces a matrix for use by \code{\link{rand_plot}}.
Understands replicates within \code{k} values.
}
