% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{density_ratio}
\alias{density_ratio}
\title{Density Ratio}
\usage{
density_ratio(g, com, type = "local")
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have a "weight"
attribute, those will be used as weights.}

\item{com}{community membership integer vector. Each element corresponds to a vertex.}

\item{type}{can either be "local" or "global"}
}
\value{
Numeric vector with the internal density of each community.
}
\description{
Density ratio of a graph's communities.
}
\examples{
data(karate, package="igraphdata")
density_ratio(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{cut_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{scoring_functions}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
