% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppnewint8.R
\name{ppnewint8}
\alias{ppnewint8}
\title{Capital stock model 4 using the New Interpretation.}
\usage{
ppnewint8(A, Ap, l, lp, w, wp, v, Q, Qp, D, Dp, K, t, lp_simple)
}
\arguments{
\item{A}{input-output matrix (n x n).}

\item{Ap}{input-output matrix for the subset of productive industries (m x m).}

\item{l}{vector of complex labor input (1 x n).}

\item{lp}{vector of complex labor input for the subset of productive industries (1 x m).}

\item{w}{vector of nominal wage rates (1 x n).}

\item{wp}{vector of nominal wage rates for the subset of productive industries (1 x m).}

\item{v}{value of labor power (scalar).}

\item{Q}{gross output vector (n x 1).}

\item{Qp}{gross output vector for the subset of productive industries (m x 1).}

\item{D}{depreciation matrix (n x n).}

\item{Dp}{depreciation matrix for the subset of productive industries (m x m).}

\item{K}{capital stock coefficient matrix (n x n).}

\item{t}{turnover times matrix (n x n diagonal).}

\item{lp_simple}{vector of simple labor input for the subset of productive industries (1 x m).}
}
\value{
A list with the following elements:
\item{meig}{Maximum eigen value of A}
\item{urop}{Uniform rate of profit (as a fraction)}
\item{mrop}{Maximum rate of profit (as a fraction)}
\item{ppabs}{Price of production vector (absolute)}
\item{pprel}{Price of production vector (relative)}
\item{lvalues}{Labor values vector}
\item{mevn}{Monetary expression of value using net output}
\item{mevg}{Monetary expression of value using gross output}
\item{Nnonneg}{Is N Nonnegative? (1=Y,0=N)}
\item{Nirred}{Is N Irreducible? (1=Y,0=N)}
}
\description{
This function computes the uniform rate of profit, prices of production and labor values for a capital stock model using the New Interpretation. The model allows differential wage rates across industries and takes account of unproductive labor for labor value calculations.
}
\examples{

# ------ Data
# Input-output matrix
A <- matrix(
data = c(0.265,0.968,0.00681,0.0121,0.391,0.0169,0.0408,0.808,0.165),
nrow=3, ncol=3, byrow = TRUE
)
# Direct labor input vector (complex)
l <- matrix(
data = c(0.193, 3.562, 0.616),
nrow=1
)
# Real wage bundle
b <- matrix(
data = c(0.0109, 0.0275, 0.296),
ncol=1
)
# Gross output vector
Q <- matrix(
data = c(26530, 18168, 73840),
ncol=1
)
# Direct labor input vector (simple)
l_simple <- l
# Market price vector
m <- matrix(data = c(4, 60, 7),nrow=1)
# Uniform nominal wage rate
wavg <- m\%*\%b
# Vector of nominal wage rates
w <- matrix(data=c(wavg-0.5,wavg,wavg+0.5),nrow=1)
# Value of labor power
v <- 3/5
# Depreciation matrix
D <- matrix(data = c(0,0,0,0.00568,0.0267,0.0028,0.00265,0.0147,0.00246),
nrow=3, ncol=3, byrow = TRUE
)
# Capital stock coefficient matrix
K <- matrix(
data = c(0,0,0,0.120,0.791,0.096,0.037,0.251,0.043),
nrow=3, ncol=3, byrow = TRUE
)
# Diagonal turnover matrix
t <- diag(c(0.317, 0.099, 0.187))
# Compute prices of production
ppnewint8(A=A,Ap=A[1:2,1:2],l=l,lp=l[1,1:2],w=w[1,],wp=w[1,1:2],v=v,
Q=Q,Qp=Q[1:2,1],lp_simple=l[1,1:2],D=D,Dp=D[1:2,1:2],K=K,t=t)

}
\references{
Basu, Deepankar and Moraitis, Athanasios, "Alternative Approaches to Labor Values andPrices of Production: Theory and Evidence" (2023). Economics Department Working Paper Series. 347. URL: https://scholarworks.umass.edu/econ_workingpaper/347/
}
