% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.clmstan}
\alias{predict.clmstan}
\title{Predict method for clmstan objects}
\usage{
\method{predict}{clmstan}(
  object,
  newdata = NULL,
  type = c("class", "probs"),
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ndraws = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{clmstan} object returned by \code{\link[=clm_stan]{clm_stan()}}.}

\item{newdata}{Optional data frame for prediction. If \code{NULL} (default),
predictions are made for the original training data.}

\item{type}{Type of prediction:
\itemize{
\item \code{"class"}: Predicted category (most likely class)
\item \code{"probs"}: Predicted probabilities for each category
}}

\item{summary}{Logical. If \code{TRUE} (default), return summary statistics
(mean, SD, quantiles). If \code{FALSE}, return raw posterior draws.}

\item{robust}{Logical. If \code{TRUE}, use median instead of mean for
point estimates. Default is \code{FALSE}.}

\item{probs}{Numeric vector of probabilities for quantiles.
Default is \code{c(0.025, 0.975)} for 95\% credible intervals.}

\item{ndraws}{Number of posterior draws to use. If \code{NULL} (default),
all available draws are used.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Depending on \code{type} and \code{summary}:
\itemize{
\item \code{type = "class"}, \code{summary = TRUE}: A data frame with columns
\code{Estimate} (mean/median predicted class), \code{Est.Error} (SD),
quantile columns, and \code{Class} (modal predicted category).
\item \code{type = "class"}, \code{summary = FALSE}: An S x N integer matrix
of predicted categories (1 to K), where S is the number of
posterior draws and N is the number of observations.
\item \code{type = "probs"}, \code{summary = TRUE}: A data frame with columns
for each category probability (\code{P[Y=1]}, \code{P[Y=2]}, etc.).
\item \code{type = "probs"}, \code{summary = FALSE}: An S x N x K array of
predicted probabilities.
}
}
\description{
Generates predictions from a fitted cumulative link model.
}
\seealso{
\code{\link[=fitted.clmstan]{fitted.clmstan()}} for expected probabilities,
\code{\link[=posterior_predict.clmstan]{posterior_predict.clmstan()}} for posterior predictive samples.
}
