\name{vte_bleed_score}
\alias{vte_bleed_score}
\title{
VTE-BLEED Score
}
\description{
Calculates the VTE-BLEED score to predict the risk of major bleeding during chronic anticoagulation therapy (stable anticoagulation after the first month) in patients with venous thromboembolism (VTE).
}
\usage{
vte_bleed_score(active_cancer, sex, uncontrolled_hypertension, anemia,
                history_of_bleeding, age, renal_dysfunction)
}
\arguments{
  \item{active_cancer}{
Numeric (0 or 1). Presence of active cancer (excluding basal cell or squamous cell carcinoma of the skin). (1 = Yes, +2 points).
}
  \item{sex}{
String. Patient sex. ("male" or "female"). Note: Male sex combined with uncontrolled hypertension adds +1 point.
}
  \item{uncontrolled_hypertension}{
Numeric (0 or 1). Presence of uncontrolled arterial hypertension (SBP > 140 mmHg). (1 = Yes).
}
  \item{anemia}{
Numeric (0 or 1). Presence of anemia (Hemoglobin < 13 g/dL for men, < 12 g/dL for women). (1 = Yes, +1.5 points).
}
  \item{history_of_bleeding}{
Numeric (0 or 1). History of prior bleeding (major or non-major clinically relevant). (1 = Yes, +1.5 points).
}
  \item{age}{
Numeric. Patient age in years. (>= 60 years adds +1.5 points).
}
  \item{renal_dysfunction}{
Numeric (0 or 1). Renal dysfunction (Creatinine clearance < 60 mL/min). (1 = Yes, +1.5 points).
}
}
\value{
A list containing:
\item{VTE_BLEED_Score}{The calculated total score (Range 0-9).}
\item{Risk_Category}{Classification (Low Risk < 2, High Risk >= 2).}
\item{Observed_Bleeding_Rate}{Estimated incidence of major bleeding based on the derivation cohort.}
}
\references{
Klok FA, Barco S, Konstantinides SV, et al. External validation of the VTE-BLEED score for predicting major bleeding in stable anticoagulated patients with venous thromboembolism. Thromb Haemost. 2017;117(6):1164-1170. doi:10.1160/TH16-12-0929
}
\examples{

# Example 1: Low Risk
# Female, 50yo, No comorbidities
vte_bleed_score(0, "female", 0, 0, 0, 50, 0)

# Example 2: High Risk
# Male, Uncontrolled HTN (+1), Age 65 (+1.5)
# Score = 2.5
vte_bleed_score(0, "male", 1, 0, 0, 65, 0)
}
