\name{rule_of_7s_lyme}
\alias{rule_of_7s_lyme}
\title{
Rule of 7's for Lyme Meningitis
}
\description{
Calculates the Rule of 7's to stratify the risk of Lyme meningitis in children presenting with aseptic meningitis. A patient is classified as "Low Risk" if they meet all three criteria: Headache duration < 7 days, CSF mononuclear cells < 70\%, and absence of 7th cranial nerve palsy. Failure of any criterion warrants further investigation for Lyme disease.
}
\usage{
rule_of_7s_lyme(headache_duration_days, csf_mononuclear_percent, seventh_nerve_palsy)
}
\arguments{
  \item{headache_duration_days}{
Numeric. Duration of headache in days.
}
  \item{csf_mononuclear_percent}{
Numeric. Percentage of mononuclear cells in the Cerebrospinal Fluid (CSF).
}
  \item{seventh_nerve_palsy}{
Numeric (0 or 1). Presence of 7th cranial nerve palsy (facial palsy). (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Classification}{"Low Risk" or "Not Low Risk".}
\item{Management_Guidance}{Clinical suggestions based on the risk level.}
\item{Risk_Factors_Present}{List of specific criteria that failed the low-risk check.}
}
\references{
Garro AC, Rutman M, Simonsen K, et al. Prospective validation of a clinical prediction model for Lyme meningitis in children. Pediatrics. 2009;123(5):e829-834. doi:10.1542/peds.2008-2425
}
\examples{

# Example 1: Low Risk
# 3 days headache, 50% monos, No palsy
rule_of_7s_lyme(3, 50, 0)

# Example 2: High Risk (Failed duration and monos)
# 10 days headache, 80% monos, No palsy
rule_of_7s_lyme(10, 80, 0)
}
