\name{leibovich_2018_rcc}
\alias{leibovich_2018_rcc}
\title{
2018 Leibovich Model for Renal Cell Carcinoma (RCC) Prognosis
}
\description{
Calculates the 2018 update to the Leibovich prognostic score for non-metastatic clear cell renal cell carcinoma (ccRCC). This model predicts progression-free survival (metastasis-free) and cancer-specific survival based on pathologic stages, tumor size, nuclear grade, and histologic necrosis.

The scoring stratifies patients into Low Risk (0-2 points), Intermediate Risk (3-5 points), and High Risk (>= 6 points).
}
\usage{
leibovich_2018_rcc(t_stage, n_stage, tumor_size_cm, nuclear_grade, necrosis)
}
\arguments{
  \item{t_stage}{
String. Pathologic T stage. Accepted values: "1a", "1b", "2a", "2b", "3a", "3b", "3c", "4". (Prefixes "p" or "T" are stripped automatically).
}
  \item{n_stage}{
String. Pathologic N stage. Accepted values: "Nx", "N0", "N1". (Prefixes "p" or "N" are stripped automatically).
}
  \item{tumor_size_cm}{
Numeric. Tumor size in centimeters.
}
  \item{nuclear_grade}{
Numeric. Fuhrman or ISUP nuclear grade (1, 2, 3, or 4).
}
  \item{necrosis}{
Numeric (0 or 1). Presence of histologic tumor necrosis. 0 = No, 1 = Yes.
}
}
\value{
A list containing the calculated Score, the associated Risk Group, and lists for Progression/Metastasis-Free Survival and Cancer-Specific Survival probabilities at 1, 3, 5, and 10 years.
}
\references{
Leibovich BC, Lohse CM, Cheville JC, et al. Predicting Oncologic Outcomes in Renal Cell Carcinoma After Surgery. Eur Urol. 2018;73(5):772-780. doi:10.1016/j.eururo.2018.01.005
}
\examples{

# Example 1: High Risk Patient
# pT3a, N0, 11cm tumor, Grade 4, with Necrosis
leibovich_2018_rcc("3a", "N0", 11, 4, 1)

# Example 2: Low Risk Patient
# pT1a, Nx, 4cm tumor, Grade 2, No Necrosis
leibovich_2018_rcc("T1a", "Nx", 4, 2, 0)
}
