\name{herdoo2_rule}
\alias{herdoo2_rule}
\title{
HERDOO2 Rule for Discontinuing Anticoagulation in Unprovoked VTE
}
\description{
Calculates the HERDOO2 score to identify women with unprovoked venous thromboembolism (VTE) who have a low risk of recurrence and can safely discontinue anticoagulation. Men are considered high risk regardless of the score and should generally continue anticoagulation.
}
\usage{
herdoo2_rule(post_thrombotic_signs, d_dimer_ge_250, bmi_ge_30, age_ge_65)
}
\arguments{
  \item{post_thrombotic_signs}{
Numeric (0 or 1). Presence of post-thrombotic signs (Hyperpigmentation, Edema, or Redness in either leg). (1 = Yes, +1 point).
}
  \item{d_dimer_ge_250}{
Numeric (0 or 1). D-dimer level >= 250 µg/L on anticoagulation. (1 = Yes, +1 point).
}
  \item{bmi_ge_30}{
Numeric (0 or 1). Body Mass Index >= 30 kg/m^2. (1 = Yes, +1 point).
}
  \item{age_ge_65}{
Numeric (0 or 1). Patient age >= 65 years. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{HERDOO2_Score}{The calculated score (Range 0-4).}
\item{Risk_Category}{"Low Risk" (Score 0-1) or "High Risk" (Score >= 2).}
\item{Recommendation}{Guidance on continuing vs. stopping anticoagulation.}
}
\references{
Rodger MA, Le Gal G, Anderson DR, et al. Validating the HERDOO2 rule to guide treatment duration for women with unprovoked venous thrombosis: multinational prospective cohort management study. BMJ. 2017;356:j1065. doi:10.1136/bmj.j1065
}
\examples{

# Example 1: Low Risk Woman
# No PTS signs, D-dimer 200, BMI 25, Age 50
# Score = 0
herdoo2_rule(0, 0, 0, 0)

# Example 2: High Risk Woman
# Edema present (+1), Age 70 (+1)
# Score = 2
herdoo2_rule(1, 0, 0, 1)
}
