\name{fat_free_mass}
\alias{fat_free_mass}
\title{
Fat-Free Mass (Janmahasatian Equation)
}
\description{
Calculates the Fat-Free Mass (FFM) of a patient using the Janmahasatian equation. This metric is often used for pharmacokinetic dosing of drugs with narrow therapeutic indices (e.g., digoxin, aminoglycosides) in obese patients, as it provides a more accurate estimate of metabolically active tissue than total body weight or ideal body weight.
}
\usage{
fat_free_mass(weight_kg, height_cm, sex)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient actual body weight in kilograms.
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
}
\value{
A list containing:
\item{Fat_Free_Mass_kg}{The calculated Fat-Free Mass in kg.}
\item{BMI}{The calculated Body Mass Index used in the equation.}
}
\references{
Janmahasatian S, Duffull SB, Ash S, Ward LC, Byrne NM, Green B. Quantification of lean bodyweight. Clin Pharmacokinet. 2005;44(10):1051-1065. doi:10.2165/00003088-200544100-00004
}
\examples{

# Example 1: Male
# 80kg, 180cm
fat_free_mass(80, 180, "male")

# Example 2: Female
# 70kg, 165cm
fat_free_mass(70, 165, "female")
}
