\name{bops_pediatric_pain}
\alias{bops_pediatric_pain}
\title{
Behavioral Observational Pain Scale (BOPS)
}
\description{
Calculates the Behavioral Observational Pain Scale (BOPS) score for assessing postoperative pain in children aged 1-7 years. The scale evaluates three behavioral domains: Facial Expression, Verbalization, and Body Position. A score of 3 or greater typically indicates the need for analgesic intervention.
}
\usage{
bops_pediatric_pain(facial_expression, verbalization, body_position)
}
\arguments{
  \item{facial_expression}{
Numeric (0-2).
0: Neutral, positive, or smiling.
1: Negative facial expression.
2: Grimace.
}
  \item{verbalization}{
Numeric (0-2).
0: Normal conversation, silence, laughter, or crying not related to pain.
1: Complaining, moaning, or whimpering.
2: Crying or screaming related to pain.
}
  \item{body_position}{
Numeric (0-2).
0: Lying quietly, normal position, or moves easily.
1: Restless, shifting, or touching wound.
2: Rigid or protecting wound.
}
}
\value{
A list containing:
\item{BOPS_Score}{The calculated total score (Range 0-6).}
\item{Interpretation}{Clinical guidance based on the threshold of 3.}
}
\references{
Hesselgard K, Larsson S, Romner B, Strömblad LG, Reinstrup P. Validity and reliability of the Behavioural Observational Pain Scale for postoperative pain measurement in children 1-7 years of age. Pediatr Crit Care Med. 2007;8(2):102-108. doi:10.1097/01.PCC.0000257098.32286.2D
}
\examples{

# Example 1: Significant Pain
# Grimace (2), Crying (2), Restless (1)
# Score = 5
bops_pediatric_pain(2, 2, 1)

# Example 2: No Pain
# Smiling (0), Normal talk (0), Moving easily (0)
# Score = 0
bops_pediatric_pain(0, 0, 0)
}
