\name{body_fluid_balance}
\alias{body_fluid_balance}
\title{
Body Fluid Balance Calculator
}
\description{
Calculates the net fluid balance over a specified period (typically 24 hours) by summing all sources of fluid intake (Input) and subtracting all sources of fluid loss (Output). This calculation is critical for monitoring hydration status in hospitalized patients, particularly those with heart failure, kidney disease, or shock.
}
\usage{
body_fluid_balance(oral_input_ml = 0, iv_input_ml = 0, enteral_input_ml = 0,
                   other_input_ml = 0, urine_output_ml = 0, stool_output_ml = 0,
                   emesis_ng_output_ml = 0, drain_output_ml = 0,
                   insensible_loss_ml = 0)
}
\arguments{
  \item{oral_input_ml}{
Numeric. Total volume of fluid consumed orally (PO) in milliliters.
}
  \item{iv_input_ml}{
Numeric. Total volume of intravenous (IV) fluids administered in milliliters (including continuous infusions, boluses, and medication volumes).
}
  \item{enteral_input_ml}{
Numeric. Total volume of enteral nutrition (tube feeds) and water flushes in milliliters.
}
  \item{other_input_ml}{
Numeric. Any other fluid intake (e.g., blood products) in milliliters.
}
  \item{urine_output_ml}{
Numeric. Total volume of urine produced in milliliters.
}
  \item{stool_output_ml}{
Numeric. Estimated volume of liquid stool or ostomy output in milliliters.
}
  \item{emesis_ng_output_ml}{
Numeric. Volume of vomit or nasogastric (NG) tube output in milliliters.
}
  \item{drain_output_ml}{
Numeric. Volume from surgical drains, chest tubes, etc., in milliliters.
}
  \item{insensible_loss_ml}{
Numeric. Estimated insensible losses (skin, respiration) in milliliters. Often estimated as 500-800 mL/day or 10 mL/kg/day in adults, though highly variable with fever or ventilation.
}
}
\value{
A list containing:
\item{Net_Fluid_Balance_mL}{The calculated balance (Input - Output).}
\item{Status}{Description of the balance (Positive, Negative, or Neutral).}
\item{Summary}{Total summed Input and Output values.}
\item{Detailed_Inputs}{Breakdown of input sources.}
\item{Detailed_Outputs}{Breakdown of output sources.}
}
\references{
Mazzoni D, et al. Fluid Balance. In: StatPearls. Treasure Island (FL): StatPearls Publishing. 2023.
}
\examples{

# Example 1: Positive Balance (Fluid Overload concern)
# 2L IV, 500mL Oral, 1L Urine, no other losses
body_fluid_balance(oral_input_ml = 500, iv_input_ml = 2000, urine_output_ml = 1000)

# Example 2: Negative Balance (Dehydration/Diuresis)
# 1L Oral, 2L Urine, 500mL Insensible
body_fluid_balance(oral_input_ml = 1000, urine_output_ml = 2000, insensible_loss_ml = 500)
}
