\name{assure_rcc_prognosis}
\alias{assure_rcc_prognosis}
\title{
ASSURE Renal Cell Carcinoma Prognosis
}
\description{
Calculates the prognostic risk group (Low, Intermediate, High) for Disease-Free Survival (DFS) and Overall Survival (OS) in patients with resected intermediate- or high-risk localized Renal Cell Carcinoma (RCC). This model is based on data from the ASSURE (E2805) clinical trial and incorporates histology, grade, necrosis, and vascular invasion.
}
\usage{
assure_rcc_prognosis(histology, fuhrman_grade, tumor_size_cm, necrosis,
                     vascular_invasion, nodal_involvement, sarcomatoid)
}
\arguments{
  \item{histology}{
String. Histological subtype: "clear cell", "papillary type 1", "papillary type 2", "chromophobe", "mixed", or "other".
}
  \item{fuhrman_grade}{
Numeric (1-4). Fuhrman nuclear grade.
}
  \item{tumor_size_cm}{
Numeric. Maximum tumor diameter in centimeters.
}
  \item{necrosis}{
Numeric (0 or 1). Presence of coagulative tumor necrosis. (1 = Yes).
}
  \item{vascular_invasion}{
String. Extent of vascular invasion: "none", "segmental", "renal vein", or "caval".
}
  \item{nodal_involvement}{
Numeric (0 or 1). Presence of pathological lymph node metastasis. (1 = Yes).
}
  \item{sarcomatoid}{
Numeric (0 or 1). Presence of sarcomatoid features. (1 = Yes).
}
}
\value{
A list containing:
\item{Total_Points}{The calculated prognostic score based on the nomogram weights.}
\item{DFS_Risk_Group}{Risk group for Disease-Free Survival (Low, Intermediate, High).}
\item{OS_Risk_Group}{Risk group for Overall Survival (Low, Intermediate, High).}
}
\references{
Correa AF, et al. Predicting Disease Recurrence, Early Progression, and Overall Survival Following Surgical Resection for High-risk Localized and Locally Advanced Renal Cell Carcinoma. Eur Urol. 2021;80(2):20-31.
}
\examples{

# Example 1: High Risk
# Clear Cell, Grade 4, 8cm, Necrosis, Renal Vein Inv, N1
# Points: 35 (Hist) + 78 (Gr4) + 32 (Size) + 23 (Necr) + 30 (Vasc) + 65 (Node) = 263 -> High
assure_rcc_prognosis("clear cell", 4, 8.0, 1, "renal vein", 1, 0)

# Example 2: Low Risk
# Chromophobe, Grade 2, 4cm, No Necrosis, No Vasc, N0
# Points: 0 (Hist) + 13 (Gr2) + 16 (Size) = 29 -> Low
assure_rcc_prognosis("chromophobe", 2, 4.0, 0, "none", 0, 0)
}
