% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_clindoc}
\alias{write_clindoc}
\title{Clintable write method}
\usage{
write_clindoc(x, file)
}
\arguments{
\item{x}{a clintable object}

\item{file}{The file path to which the file should be written}
}
\value{
Invisible
}
\description{
Write a clinify table out to a docx file
}
\examples{
ct <- clintable(mtcars)

ct <- clin_alt_pages(
  ct,
  key_cols = c("mpg", "cyl", "hp"),
  col_groups = list(
    c("disp", "drat", "wt"),
    c("qsec", "vs", "am"),
    c("gear", "carb")
  )
)

# Get document object directly
doc <- clindoc(ct)

# Write out docx file
write_clindoc(ct, file.path(tempdir(), "demo.docx"))

}
