% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_math.R
\name{set_abs}
\alias{set_abs}
\alias{set_floor}
\alias{set_ceiling}
\alias{set_trunc}
\alias{set_exp}
\alias{set_sqrt}
\alias{set_change_sign}
\alias{set_round}
\alias{set_log}
\alias{set_pow}
\alias{set_add}
\alias{set_subtract}
\alias{set_multiply}
\alias{set_divide}
\title{Math operations by reference - \bold{Experimental}}
\usage{
set_abs(x)

set_floor(x)

set_ceiling(x)

set_trunc(x)

set_exp(x)

set_sqrt(x)

set_change_sign(x)

set_round(x, digits = 0)

set_log(x, base = exp(1))

set_pow(x, y)

set_add(x, y)

set_subtract(x, y)

set_multiply(x, y)

set_divide(x, y)
}
\arguments{
\item{x}{\verb{[numeric(n)]} vector.}

\item{digits}{\verb{[numeric(n)]} - Number of digits to round to.}

\item{base}{\verb{[numeric(n)]} - Logarithm base.}

\item{y}{\verb{[numeric(n)]} vector.}
}
\value{
The exact same object with no copy made, just transformed.
}
\description{
These functions transform your variable by reference, with no copies being made.
It is advisable to only use these if you know what you are doing.
}
\details{
These functions are particularly useful for situations
where you have made a copy and then
wish to perform further operations without creating more copies. \cr
\code{NA} and \code{NaN} values are ignored though in some instances \code{NaN} values may
be replaced with \code{NA}.
These functions will \bold{not work} on \bold{any} classed objects, meaning they
only work on standard integer and numeric vectors and matrices. \cr
\subsection{When a copy has to be made}{

A copy is only made in certain instances, e.g. when passing an integer vector
to \code{set_log()}. A warning will always be thrown in this instance alerting the user
to assign the output to an object because \code{x} has not been updated by reference. \cr
To ensure consistent and expected outputs, always assign the output to the same object, \cr e.g.
\code{x <- set_log(x)} (\bold{do this}) \cr
\code{set_log(x)} (\bold{don't do this}) \cr
\code{x2 <- set_log(x)} (Don't do this either) \cr
\cr No copy is made here unless x is an integer vector.
}
}
\examples{
library(cheapr)
library(bench)

x <- rnorm(2e05)
mark(
  base = exp(log(abs(x))),
  cheapr = set_exp(set_log(set_abs(x)))
)

}
