% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{simCostData}
\alias{simCostData}
\title{Simulates censored cost data}
\usage{
simCostData(n = 100, dist = "unif", censor = "light", cdist = "exp", L = 10)
}
\arguments{
\item{n}{Number of individuals to simulate}

\item{dist}{Survival distribution either "unif" = unif(0,10) o r "exp" = exp (1/6)}

\item{censor}{Censoring "light" ~ 25\% or "heavy" ~ 40\%, changes a bit depending on cdist}

\item{cdist}{Distribution used to censor, "exp" exponential or "unif" uniform}

\item{L}{Number of years to summarize over}
}
\value{
Simulation of censored cost
}
\description{
This function can be used to demonstrate the bias and coverage 
of the estimators in the ccmean function
}
\details{
The function simulates survival times from either an uniform distribution 
or an exponential distribution, and a cost history. There are two options for censoring, heavy (~40%) or
light (~25%). The simulation is inspired by Lin (1997).
}
\examples{
# The simulated data can be used to show how the estimators perform

simCostData(n = 100, dist = "unif", censor = "light", cdist = "exp", L = 10)

}
\references{
\insertRef{Lin1997}{ccostr}
}
