% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_download_meta.R
\name{cbs_download_meta}
\alias{cbs_download_meta}
\title{Dumps the meta data into a directory}
\usage{
cbs_download_meta(
  id,
  dir = id,
  catalog = "CBS",
  ...,
  verbose = FALSE,
  cache = FALSE,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{Id of CBS open data table (see \code{\link[=cbs_get_toc]{cbs_get_toc()}})}

\item{dir}{Directory in which data should be stored.
By default it creates a sub directory with the name of the id}

\item{catalog}{catalog id, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{...}{not used}

\item{verbose}{Print extra messages what is happening.}

\item{cache}{Should meta data be cached?}

\item{base_url}{optionally allow to specify a different server. Useful for
third party data services implementing the same protocol, see details.}
}
\value{
meta data object
}
\description{
Dumps the meta data into a directory
}
\section{Specify different server}{


Besides the official CBS data, there are also third party and preview dataservices
implementing the same protocol. The \code{base_url} parameter allows to specify a different server.
The \code{base_url} can either be specified explicitly or set globally with with
\code{options(cbsodataR.base_url = "http://example.com")}.
Some further tweaking may be necessary for third party services, a download url
is constructed using: either with:
\itemize{
\item \verb{<base_url>/<BULK>/<id>/...} for data
\item \verb{<base_url>/<API>/<id>/?$format=json} for metadata
}

Default values for \code{BASEURL}, \code{BULK} and \code{API} are set in the package options,
but can be changed with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(
 cbsodataR.base_url = "https://opendata.cbs.nl",
 cbsodataR.BULK = "ODataFeed/odata",
 cbsodataR.API = "ODataAPI/odata"
)
}\if{html}{\out{</div>}}

which are the default values set in the package.
}

\seealso{
Other meta data: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_add_unit_column}()},
\code{\link{cbs_get_meta}()}

Other download: 
\code{\link{cbs_download_data}()},
\code{\link{cbs_download_table}()}
}
\concept{download}
\concept{meta data}
