% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reachable_states_light.R
\name{get_reachable_states_light}
\alias{get_reachable_states_light}
\title{Find Cycle Length (Lightweight Version)}
\usage{
get_reachable_states_light(start_state, allowed_positions, k)
}
\arguments{
\item{start_state}{Integer vector, the initial permutation state}

\item{allowed_positions}{Character vector, sequence of operations to repeat}

\item{k}{Integer, parameter for reverse operations}
}
\value{
List containing:
\item{total_moves}{Total number of moves to return to start state}
\item{unique_states_count}{Number of unique states in the cycle}
}
\description{
Fast version of cycle detection that only returns cycle length and unique
state count without storing all intermediate states. Useful for testing
many operation sequences efficiently.
}
\examples{
# Quick cycle length check
result <- get_reachable_states_light(1:20, c("L", "X", "L"), k = 4)
cat("Cycle length:", result$total_moves, "\n")
cat("Unique states:", result$unique_states_count, "\n")

# Compare multiple sequences
seq1 <- get_reachable_states_light(1:20, c("1", "3"), k = 4)
seq2 <- get_reachable_states_light(1:20, c("2", "3"), k = 4)
cat("Sequence 1 cycle:", seq1$total_moves, "\n")
cat("Sequence 2 cycle:", seq2$total_moves, "\n")
}
