% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-data.R
\name{generate_qualitative_data_rd}
\alias{generate_qualitative_data_rd}
\title{Generate Qualitative Data (Regression Discontinuity)}
\usage{
generate_qualitative_data_rd(n, outcome_type)
}
\arguments{
\item{n}{Sample size.}

\item{outcome_type}{String controlling the outcome type. Must be either \code{"multinomial"} or \code{"ordered"}. Affects how potential outcomes are generated.}
}
\value{
A list storing a data frame with the observed data, and the true probabilities of shift at the cutoff.
}
\description{
Generate a synthetic data set with qualitative outcomes under a regression discontinuity design. The data include a binary treatment indicator and a single covariate (the running variable). The conditional
probability mass fuctions of potential outcomes are continuous in the running variable.
}
\details{
\subsection{Outcome type}{

Potential outcomes are generated differently according to \code{outcome_type}. If \code{outcome_type == "multinomial"}, \code{\link{generate_qualitative_data_rd}} computes linear predictors for each class using the covariates:

\deqn{\eta_{mi} (d) = \beta_{m1}^d X_{i1} + \beta_{m2}^d X_{i2} + \beta_{m3}^d X_{i3}, \quad d = 0, 1,}

and then transforms \eqn{\eta_{mi} (d)} into valid probability distributions using the softmax function:

\deqn{P(Y_i(d) = m | X_i) = \frac{\exp(\eta_{mi} (d))}{\sum_{m'} \exp(\eta_{m'i}(d))}.}

It then generates potential outcomes \eqn{Y_i(1)} and \eqn{Y_i(0)} by sampling from \{1, 2, 3\} using \eqn{P(Y_i(d) = m | X_i), \, d = 0, 1}.\cr

If instead \code{outcome_type == "ordered"}, \code{\link{generate_qualitative_data_rd}} first generates latent potential outcomes:

\deqn{Y_i^* (d) = \tau d + X_{i1} + X_{i2} + X_{i3} + N (0, 1), \quad d = 0, 1,}

with \eqn{\tau = 2}. It then constructs \eqn{Y_i (d)} by discretizing \eqn{Y_i^* (d)} using threshold parameters \eqn{\zeta_1 = 2} and \eqn{\zeta_2 = 4}. Then,

\deqn{P(Y_i(d) = m) = P(\zeta_{m-1} < Y_i^*(d) \leq \zeta_m) = \Phi (\zeta_m - \sum_j X_{ij} - \tau d) - \Phi (\zeta_{m-1} - \sum_j X_{ij} - \tau d), \quad d = 0, 1,}

which allows us to analytically compute the probabilities of shift at the cutoff.
}

\subsection{Treatment assignment}{

Treatment is always assigned as \eqn{D_i = 1(X_i \geq 0.5)}.
}

\subsection{Other details}{

The function always generates three independent covariates from \eqn{U(0,1)}. Observed outcomes \eqn{Y_i} are always constructed using the usual observational rule.
}
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_qualitative_data_rd(100,
                                     outcome_type = "ordered")

data$pshifts_cutoff}

}
\seealso{
\code{\link{generate_qualitative_data_soo}} \code{\link{generate_qualitative_data_iv}} \code{\link{generate_qualitative_data_did}}
}
\author{
Riccardo Di Francesco
}
