% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{outcome_lp}
\alias{outcome_lp}
\title{Calculate linear predictor from covariates}
\usage{
outcome_lp(
  data,
  mean = NULL,
  par = NULL,
  model = NULL,
  offset = NULL,
  treatment = NULL,
  intercept = TRUE,
  default.parameter = 0,
  family = gaussian(),
  remove = c("id", "num"),
  ...
)
}
\arguments{
\item{data}{(data.table) Covariate data, usually the output of the covariate
model of a \link{Trial} object.}

\item{mean}{formula specifying design from 'data' or a function that maps x
to the mean value. If NULL all main-effects of the covariates will be used}

\item{par}{(numeric) Regression coefficients (default zero). Can be given as
a named list corresponding to the column names of \code{model.matrix}}

\item{model}{Optional model object (\link{glm}, \link[mets:phreg]{mets::phreg}, ...)}

\item{offset}{Optional offset variable name}

\item{treatment}{Optional name of treatment variable}

\item{intercept}{When FALSE the intercept will removed from the design matrix}

\item{default.parameter}{when \code{model} and \code{treatment} is specified,
interaction terms between \code{treatment} and all other covariates in \code{model}
is added to the simulation model. \code{default.parameter} specifies the default
parameter of these extra parameters which can be changed individually with
the \code{par} argument.}

\item{family}{family (default 'gaussian(identity)'). The inverse
link-function is used to map the mean to the linear predictor scale (if
mean is given as a function)}

\item{remove}{variables that will be removed from input data (if formula is
not specified)}

\item{...}{Additional arguments passed to \code{mean} function (see examples)}
}
\value{
data.table
}
\description{
Calculate linear predictor \deqn{\text{par}^\top X} where
\eqn{X} is the design matrix specified by the formula
}
