% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/felm.R
\name{felm}
\alias{felm}
\title{LM fitting with high-dimensional k-way fixed effects}
\usage{
felm(formula = NULL, data = NULL, weights = NULL, control = NULL)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description of
the model to be fitted. \code{formula} must be of type \code{y ~ X | k},
where the second part of the formula refers to factors to be concentrated
out. It is also possible to pass clustering variables to \code{\link{feglm}}
as \code{y ~ X | k | c}.}

\item{data}{an object of class \code{"data.frame"} containing the variables
in the model. The expected input is a dataset with the variables specified
in \code{formula} and a number of rows at least equal to the number of
variables in the model.}

\item{weights}{an optional string with the name of the 'prior weights'
variable in \code{data}.}

\item{control}{a named list of parameters for controlling the fitting
process. See \code{\link{fit_control}} for details.}
}
\value{
A named list of class \code{"felm"}. The list contains the following
eleven elements:
\item{coefficients}{a named vector of the estimated coefficients}
\item{fitted_values}{a vector of the estimated dependent variable}
\item{weights}{a vector of the weights used in the estimation}
\item{hessian}{a matrix with the numerical second derivatives}
\item{null_deviance}{the null deviance of the model}
\item{nobs}{a named vector with the number of observations used in the
estimation indicating the dropped and perfectly predicted observations}
\item{fe_levels}{a named vector with the number of levels in each fixed
effect}
\item{nms_fe}{a list with the names of the fixed effects variables}
\item{formula}{the formula used in the model}
\item{data}{the data used in the model after dropping non-contributing
observations}
\item{control}{the control list used in the model}
}
\description{
A wrapper for \code{\link{feglm}} with
\code{family = gaussian()}.
}
\examples{
# check the feglm examples for the details about clustered standard errors
mod <- felm(log(mpg) ~ log(wt) | cyl, mtcars)
summary(mod)

}
\references{
Gaure, S. (2013). "OLS with Multiple High Dimensional Category
Variables". Computational Statistics and Data Analysis, 66.

Marschner, I. (2011). "glm2: Fitting generalized linear models
with convergence problems". The R Journal, 3(2).

Stammann, A., F. Heiss, and D. McFadden (2016). "Estimating Fixed
Effects Logit Models with Large Panel Data". Working paper.

Stammann, A. (2018). "Fast and Feasible Estimation of Generalized
Linear Models with High-Dimensional k-Way Fixed Effects". ArXiv e-prints.
}
