% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survreg.R
\name{axe-survreg}
\alias{axe-survreg}
\alias{axe_call.survreg}
\alias{axe_data.survreg}
\alias{axe_env.survreg}
\title{Axing an survreg.}
\usage{
\method{axe_call}{survreg}(x, verbose = FALSE, ...)

\method{axe_data}{survreg}(x, verbose = FALSE, ...)

\method{axe_env}{survreg}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed survreg object.
}
\description{
survreg objects are created from the \pkg{survival} package. They
are returned from the \code{survreg} function, representing fitted
parametric survival models.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "survival"))) withAutoprint(\{ # examplesIf}
# Load libraries
library(parsnip)
library(survival)

# Create model and fit
survreg_fit <- survival_reg(dist = "weibull") |>
  set_engine("survival") |>
  fit(Surv(futime, fustat) ~ 1, data = ovarian)

out <- butcher(survreg_fit, verbose = TRUE)

# Another survreg object
wrapped_survreg <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- survreg(Surv(time, status) ~ ph.ecog + age + strata(sex),
                 data = lung)
  return(fit)
}

# Remove junk
cleaned_survreg <- butcher(wrapped_survreg(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_survreg)
\dontshow{\}) # examplesIf}
}
