% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card}
\alias{card}
\title{A Bootstrap card component}
\usage{
card(
  ...,
  full_screen = FALSE,
  height = NULL,
  max_height = NULL,
  min_height = NULL,
  fill = TRUE,
  class = NULL,
  wrapper = card_body,
  id = NULL
)
}
\arguments{
\item{...}{Unnamed arguments can be any valid child of an \link[htmltools:builder]{htmltools tag} (which includes card items such as \code{\link[=card_body]{card_body()}}.
Named arguments become HTML attributes on returned UI element.}

\item{full_screen}{If \code{TRUE}, an icon will appear when hovering over the card
body. Clicking the icon expands the card to fit viewport size.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{max_height, min_height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{max_height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{max_height} in \code{\link[=card_body]{card_body()}}).}

\item{fill}{Whether or not to allow the card to grow/shrink to fit a
fillable container with an opinionated height (e.g., \code{page_fillable()}).}

\item{class}{Additional CSS classes for the returned UI element.}

\item{wrapper}{A function (which returns a UI element) to call on unnamed
arguments in \code{...} which are not already card item(s) (like
\code{\link[=card_header]{card_header()}}, \code{\link[=card_body]{card_body()}}, etc.). Note that non-card items are grouped
together into one \code{wrapper} call (e.g. given \code{card("a", "b", card_body("c"), "d")}, \code{wrapper} would be called twice, once with \code{"a"} and
\code{"b"} and once with \code{"d"}).}

\item{id}{Provide a unique identifier for the \code{card()} or \code{value_box()} to
report its full screen state to Shiny. For example, using \code{id = "my_card"},
you can observe the card's full screen state with
\code{input$my_card_full_screen}.}
}
\value{
A \code{\link[htmltools:builder]{htmltools::div()}} tag.
}
\description{
A general purpose container for grouping related UI elements together with a
border and optional padding. To learn more about \code{\link[=card]{card()}}s, see \href{https://rstudio.github.io/bslib/articles/cards/index.html}{the Cards article} or the
other articles listed in the \emph{References} section below.
}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
library(htmltools)

card(
  full_screen = TRUE,
  card_header(
    "This is the header"
  ),
  card_body(
    p("This is the body."),
    p("This is still the body.")
  ),
  card_footer(
    "This is the footer"
  )
)
\dontshow{\}) # examplesIf}
}
\references{
Several articles on the bslib website feature the card component:
\itemize{
\item \href{https://rstudio.github.io/bslib/articles/cards/index.html}{Cards}
\item \href{https://rstudio.github.io/bslib/articles/dashboards/index.html}{Get Started: Dashboards}
\item \href{https://rstudio.github.io/bslib/articles/any-project/index.html}{Get Started: Any Project}
\item \href{https://rstudio.github.io/bslib/articles/column-layout/index.html}{Column-based layouts}
\item \href{https://rstudio.github.io/bslib/articles/filling/index.html#full-screen-cards}{Filling layouts: Full-screen cards}
}
}
\seealso{
\link[=card_body]{Card item functions} create the various parts of a
card.

\code{\link[=navset_card_tab]{navset_card_tab()}}, \code{\link[=navset_card_pill]{navset_card_pill()}} and
\code{\link[=navset_card_underline]{navset_card_underline()}} create cards with tabbed navigation.

\code{\link[=layout_columns]{layout_columns()}} and \code{\link[=layout_column_wrap]{layout_column_wrap()}} help position multiple
cards into columns and rows and can also be used inside a card.

\code{\link[=layout_sidebar]{layout_sidebar()}} adds a sidebar to a card when nested in \code{\link[=card]{card()}}
or \code{\link[=card_body]{card_body()}}.

\code{\link[=value_box]{value_box()}} uses \code{\link[=card]{card()}} to highlight a showcase a key piece of
information.

Other Components: 
\code{\link{accordion}()},
\code{\link{popover}()},
\code{\link{tooltip}()},
\code{\link{value_box}()}
}
\concept{Components}
