% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_to_gt.R
\name{summary_to_flextable}
\alias{summary_to_flextable}
\title{Convert Bootstrap Summary Tables to flextable Objects}
\usage{
summary_to_flextable(summary_table, decimals = 3, conf = "95 \% CI")
}
\arguments{
\item{summary_table}{A table created using \code{boot_summary} or \code{censboot_summary}.}

\item{decimals}{The number of decimals to print for estimates and confidence intervals. The default is 3.}

\item{conf}{The text at the top of the confidence interval column in the gt table. The default is "95 \% CI".}
}
\value{
A flextable object.
}
\description{
Converts tables created using \code{boot_summary} and \code{censboot_summary} to nicely formatted \code{flextable} tables.
}
\examples{
# Bootstrap summary of a linear model for mtcars:
model <- lm(mpg ~ hp + vs, data = mtcars)
boot_summary(model, R = 99) |> summary_to_flextable()

# Export to Word:
\dontrun{
boot_summary(model, R = 99) |>
   summary_to_flextable() |>
   flextable::save_as_docx(path = "my_table.docx")
}
}
