% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-prior.R
\name{default_prior.bmmformula}
\alias{default_prior.bmmformula}
\alias{default_prior}
\title{Get Default priors for Measurement Models specified in BMM}
\usage{
\method{default_prior}{bmmformula}(object, data, model, formula = object, ...)
}
\arguments{
\item{object}{A \code{bmmformula} object}

\item{data}{An object of class data.frame, containing data of all variables
used in the model. The names of the variables must match the variable names
passed to the \code{bmmodel} object for required argurments.}

\item{model}{A description of the model to be fitted. This is a call to a
\code{bmmodel} such as \code{mixture3p()} function. Every model function has a
number of required arguments which need to be specified within the function
call. Call \code{\link[=supported_models]{supported_models()}} to see the list of supported models and
their required arguments}

\item{formula}{An object of class \code{bmmformula}. A symbolic description of the
model to be fitted.}

\item{...}{Further arguments passed to \code{\link[brms:default_prior]{brms::default_prior()}}}
}
\value{
A data.frame with columns specifying the \code{prior}, the \code{class}, the
\code{coef} and \code{group} for each of the priors specified. Separate rows contain
the information on the parameters (or parameter classes) for which priors
can be specified.
}
\description{
Obtain the default priors for a Bayesian multilevel measurement
model, as well as information for which parameters priors can be specified.
Given the \code{model}, the \code{data} and the \code{formula} for the model, this
function will return the default priors that would be used to estimate the
model. Additionally, it will return all model parameters that have no prior
specified (flat priors). This can help to get an idea about which priors
need to be specified and also know which priors were used if no
user-specified priors were passed to the \code{\link[=bmm]{bmm()}} function.

The default priors in \code{bmm} tend to be more informative than the default
priors in \code{brms}, as we use domain knowledge to specify the priors.
}
\examples{
default_prior(bmf(c ~ 1, kappa ~ 1),
  data = oberauer_lin_2017,
  model = sdm(resp_error = "dev_rad")
)
}
\seealso{
\code{\link[=supported_models]{supported_models()}}, \code{\link[brms:default_prior]{brms::default_prior()}}
}
\keyword{extract_info}
