% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list_distances.R
\name{sim_distance}
\alias{sim_distance}
\title{Compute all pairwise distances between the spatial interaction models in a
collection}
\usage{
sim_distance(
  sim_list,
  flows = c("full", "destination", "attractiveness"),
  method = c("euclidean"),
  ...
)
}
\arguments{
\item{sim_list}{a collection of spatial interaction models, an object of
class \code{sim_list}}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{method}{the distance measure to be used. Currently only \code{"euclidean"}
is supported}

\item{...}{additional parameters (not used currently)}
}
\value{
an object of class \code{"dist"}
}
\description{
This function extracts from each spatial interaction model of the collection
a vector representation derived from its flow matrix (see details). This
vector is then used to compute distances between the models.
}
\details{
The vector representation is selected using the \code{flows} parameters. Possible
values are
\itemize{
\item \code{"full"} (default value): the representation is obtained by considering
the matrix of \code{\link[=flows]{flows()}} as a vector (with the standard \code{\link[=as.vector]{as.vector()}}
function);
\item \code{"destination"}: the representation is the \code{\link[=destination_flow]{destination_flow()}} vector
associated to each spatial interaction model;
\item \code{"attractiveness"}: the representation is the \code{\link[=attractiveness]{attractiveness()}} vector
associated to each spatial interaction model.
}
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(
  distances, production, c(1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1
)
flows_distances <- sim_distance(all_flows)
inflows_distances <- sim_distance(all_flows, "destination")
}
\seealso{
\code{\link[=dist]{dist()}}
}
