% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_names.R
\name{location_names}
\alias{location_names}
\alias{location_names<-}
\title{Names of origin and destination locations in a spatial interaction model}
\usage{
location_names(sim)

location_names(sim) <- value
}
\arguments{
\item{sim}{a spatial interaction model object (an object of class \code{sim}) or a
collection of spatial interaction  models (an object of class \code{sim_list})}

\item{value}{a list with two components (see the returned value) or \code{NULL}}
}
\value{
for \code{location_names} \code{NULL} or a list with two components: \code{origin}
for the origin location names and \code{destination} for the destination
location names. For \verb{location_names<-()} the modified \code{sim} object or
\code{sim_list} object.
}
\description{
Those functions provide low level access to origin and destination local
names. It is recommended to use \code{\link[=origin_names]{origin_names()}} and \code{\link[=destination_names]{destination_names()}}
instead of \code{location_names} and \verb{location_names<-}.
}
\examples{
distances <- french_cities_distances[1:10, 1:10]
production <- rep(1, 10)
attractiveness <- rep(1, 10)
## the row/column names of the cost matrix are used for the location
model <- static_blvim(distances, production, 1.5, 1 / 250000, attractiveness)
location_names(model)
location_names(model) <- NULL
location_names(model)
location_names(model) <- list(
  origin = french_cities$name[1:10],
  destination = LETTERS[1:10]
)
destination_names(model)
origin_names(model)
}
\seealso{
\code{\link[=origin_names]{origin_names()}}, \code{\link[=destination_names]{destination_names()}}
}
