% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{grid_sim_converged}
\alias{grid_sim_converged}
\title{Reports the convergence statuses of a collection of spatial interaction
models}
\usage{
grid_sim_converged(sim, ...)
}
\arguments{
\item{sim}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{...}{additional parameters}
}
\value{
a vector of convergence status, one per spatial interaction model
}
\description{
The function reports for each spatial interaction model of its \code{sim_list}
parameter its convergence status, as defined in \code{\link[=sim_converged]{sim_converged()}}.
}
\details{
Notice that \code{\link[=sim_converged]{sim_converged()}} is generic and can be applied directly to
\code{sim_list} objects. The current function is provided to be explicit in R code
about what is a unique model and what is a collection of models (using
function names that start with \code{"grid_"})
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE,
  iter_max = 750
)
grid_sim_converged(all_flows)
}
\seealso{
\code{\link[=sim_converged]{sim_converged()}}, \code{\link[=grid_sim_iterations]{grid_sim_iterations()}} and \code{\link[=grid_blvim]{grid_blvim()}}
}
