% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_te_top3_by_type_posthoc}
\alias{summarise_te_top3_by_type_posthoc}
\title{Summarise top-3 transfer entropy results by type}
\usage{
summarise_te_top3_by_type_posthoc(te_tab, dir_csv)
}
\arguments{
\item{te_tab}{Optional data frame with transfer entropy results,
including a \code{type} column and at least \code{lag},
\code{TE_ItoC}, \code{TE_CtoI}, \code{p_ItoC}, \code{p_CtoI}.
If \code{NULL} or empty, the function attempts to read the data
from CSV files via \code{.read_te_all()}.}

\item{dir_csv}{Character scalar; directory where the transfer entropy
CSV files are stored (used when \code{te_tab} is missing).}
}
\value{
A named list with up to three elements:
\itemize{
\item \code{$counts}, \code{$rates}, \code{$binary}: each is a
data frame with columns \code{model}, \code{type},
\code{config} (direction and lag), \code{stat}, and
\code{p_value}, or \code{NULL} if no results for that type.
}
}
\description{
Produces a list of small tables with the three most significant
transfer entropy estimates for each data type (counts, rates, binary)
separately.
}
\details{
For each type in \code{c("counts", "rates", "binary")}, the function
ranks all direction-lag combinations by p-value and retains the top
three. Types with no valid rows remain \code{NULL} in the output list.
}
