% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.write_sheet}
\alias{.write_sheet}
\title{Safely write a data frame to an Excel worksheet}
\usage{
.write_sheet(wb, sheet_name, df)
}
\arguments{
\item{wb}{An \code{openxlsx} workbook object.}

\item{sheet_name}{Character scalar; name of the worksheet to create
or replace.}

\item{df}{A data frame to write. If \code{df} is \code{NULL} or has
zero rows or columns, a placeholder data frame with a single column
\code{info = "Sin datos"} is written instead.}
}
\value{
Invisibly returns \code{NULL}. The workbook \code{wb} is
modified in place.
}
\description{
Helper to write a data frame into an \pkg{openxlsx} workbook as a
table, replacing any existing sheet with the same name, applying
basic formatting, and handling empty data frames gracefully.
}
\details{
The function:
\itemize{
\item Removes the sheet \code{sheet_name} if it already exists.
\item Adds a new worksheet with that name.
\item Writes \code{df} as a data table and freezes the first row.
\item Sets column widths to \code{"auto"}.
\item Applies a bold style to the header row.
}
}
\keyword{internal}
