% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-core.R
\name{bs_peek}
\alias{bs_peek}
\title{Peek at bits from a bitstream i.e. examine bits without advancing bitstream}
\usage{
bs_peek(bs, n)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{n}{number of bits to peek.}
}
\value{
logical vector of bit values
}
\description{
Peek at bits from a bitstream i.e. examine bits without advancing bitstream
}
\examples{
raw_vec <- as.raw(1:3)
bs  <- bs_open(raw_vec, 'r')
bs_peek(bs, 4)
stopifnot(bs_is_aligned(bs))
bs_close(bs)
}
