% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{birdie-class}
\alias{birdie-class}
\alias{coef.birdie}
\alias{fitted.birdie}
\alias{residuals.birdie}
\alias{predict.birdie}
\alias{simulate.birdie}
\alias{plot.birdie}
\alias{tidy.birdie}
\alias{glance.birdie}
\alias{augment.birdie}
\alias{formula.birdie}
\alias{family.birdie}
\alias{nobs.birdie}
\alias{vcov.birdie}
\alias{print.birdie}
\alias{summary.birdie}
\title{Class "birdie" of BIRDiE Models}
\usage{
\method{coef}{birdie}(object, subgroup = FALSE, ...)

\method{fitted}{birdie}(object, ...)

\method{residuals}{birdie}(object, x_only = FALSE, ...)

\method{predict}{birdie}(object, adj = NULL, ...)

\method{simulate}{birdie}(object, nsim = 1, seed = NULL, ...)

\method{plot}{birdie}(x, log = FALSE, ...)

\method{tidy}{birdie}(x, subgroup = FALSE, ...)

\method{glance}{birdie}(x, ...)

\method{augment}{birdie}(x, data, ...)

\method{formula}{birdie}(x, ...)

\method{family}{birdie}(object, ...)

\method{nobs}{birdie}(object, ...)

\method{vcov}{birdie}(object, ...)

\method{print}{birdie}(x, ...)

\method{summary}{birdie}(object, ...)
}
\arguments{
\item{object, x}{A \code{birdie} model object}

\item{subgroup}{If \code{TRUE}, return subgroup-level (rather than marginal)
coefficient estimates as a 3D array.}

\item{...}{Potentially further arguments passed from other methods}

\item{x_only}{if \code{TRUE}, calculate fitted values using covariates only (i.e.,
without using surnames).}

\item{adj}{A point in the simplex that describes how BISG probabilities
will be thresholded to produce point predictions. The probabilities are
divided by \code{adj}, then the racial category with the highest probability is
predicted. Can be used to trade off types of prediction error. Must be
nonnegative but will be normalized to sum to 1. The default is to make no
adjustment.}

\item{nsim}{The number of vectors to simulate. Defaults to 1.}

\item{seed}{Used to seed the random number generator. See \code{\link[stats:simulate]{stats::simulate()}}.}

\item{log}{If \code{TRUE}, plot estimated probabilities on a log scale.}

\item{data}{A data frame to augment with \code{Pr(R | Y, X, S)} probabilities}
}
\value{
Varies, depending on the method. See generic functions' documentation
for details.
}
\description{
The output of \code{\link[=birdie]{birdie()}} is an object of class \code{birdie}, which supports
many generic functions. Notably \code{coef.birdie()} returns the main model
estimates of outcome given race, and \code{fitted.birdie()} returns a table
analogous to the output of \code{\link[=bisg]{bisg()}} with updated race probabilities.
}
\details{
The internal structure of \code{birdie} objects is not designed to be accessed
directly. The generics listed here should be used instead.
}
\section{Functions}{
\itemize{
\item \code{coef(birdie)}: Return estimated outcome-given-race distributions.
When \code{subgroup=FALSE} this always returns a finite-population estimate of
the outcome-given-race distribution for the observed sample.

\item \code{fitted(birdie)}: Return an updated race probability table. \code{\link[=bisg]{bisg()}}
estimates \code{Pr(R | G, X, S)}; this table is \code{Pr(R | Y, G, X, S, Theta-hat)}.

\item \code{residuals(birdie)}: Return the residuals for the outcome variable as a
matrix. Useful in sensitivity analyses and to get an idea of how well race,
location, names, etc. predict the outcome.

\item \code{predict(birdie)}: Create point predictions of individual race. Returns
factor vector of individual race labels. Strongly not recommended for any
kind of inferential purpose, as biases may be extreme and in unpredictable
directions.

\item \code{simulate(birdie)}: Simulate race from the posterior distribution
\code{Pr(R | Y, G, X, S, Theta-hat)}. Does not account for uncertainty in model
parameters.

\item \code{plot(birdie)}: Visualize the estimated conditional distributions
for a BIRDiE model. If available, marginal standard error estimates (\verb{$se})
will be visualized with 95\% confidence-level error bars.

\item \code{tidy(birdie)}: Put BIRDiE model coefficients in a tidy format.

\item \code{glance(birdie)}: Glance at a BIRDiE model.

\item \code{augment(birdie)}: Augment data with individual race predictions from a BIRDiE model.

\item \code{formula(birdie)}: Extract the formula used to specify a BIRDiE model.

\item \code{family(birdie)}: Return the BIRDiE complete-data model family.

\item \code{nobs(birdie)}: Return the number of observations used to fit a BIRDiE model.

\item \code{vcov(birdie)}: Return the estimated variance-covariance matrix for
the BIRDiE model estimates, if available.

\item \code{print(birdie)}: Print a summary of the model fit.

\item \code{summary(birdie)}: Print a more detailed summary of the model fit.

}}
\examples{
methods(class="birdie")

}
\concept{estimators}
