% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opCharMethodFunctions.R
\name{Accuracy}
\alias{Accuracy}
\title{Extract the accuracy measures from group testing results}
\usage{
Accuracy(object, individual = TRUE, ...)
}
\arguments{
\item{object}{An object of class "opChar", from which the accuracy measures
are to be extracted.}

\item{individual}{A logical argument that determines whether the accuracy
measures for each individual (\kbd{individual=TRUE}) are to be included.}

\item{...}{Additional arguments to be passed to \code{Accuracy} (e.g.,
\code{digits} to be passed to \code{round} or \code{signif} for appropriate
rounding).}
}
\value{
A list containing:
\item{Individual}{matrix detailing the accuracy measures for each individual
from \kbd{object} (for objects returned by \code{\link{opChar1}}).}
\item{Disease 1 Individual}{matrix detailing the accuracy measures
pertaining to disease 1 for each individual from \kbd{object}
(for objects returned by \code{\link{opChar2}}).}
\item{Disease 2 Individual}{matrix detailing the accuracy measures
pertaining to disease 2 for each individual from \kbd{object}
(for objects returned by \code{\link{opChar2}}).}
\item{Overall}{matrix detailing the overall accuracy measures for
the algorithm from \kbd{object}.}
}
\description{
Extract the accuracy measures from objects of class
"opchar" returned by \code{\link{operatingCharacteristics1}} (\kbd{opChar1})
or \code{\link{operatingCharacteristics2}} (\kbd{opChar2}).
}
\details{
The \kbd{Accuracy} function gives the individual accuracy measures
for each individual in \kbd{object} and the overall accuracy measures for
the algorithm. If \kbd{individual=TRUE}, individual accuracy measures
are provided for each individual specified in the \code{a} argument of the
call to \code{\link{operatingCharacteristics1}} (\kbd{opChar1})
or \code{\link{operatingCharacteristics2}} (\kbd{opChar2}).

Accuracy measures included are the pooling sensitivity, pooling
specificity, pooling positive predictive value, and pooling negative
predictive value. The overall accuracy measures displayed are weighted
averages of the corresponding individual accuracy measures for all
individuals in the algorithm. Expressions for these averages are provided
in the Supplementary Material for Hitt et al. (2019). For more information,
see the Details' section for the \code{\link{operatingCharacteristics1}}
(\kbd{opChar1}) or \code{\link{operatingCharacteristics2}} (\kbd{opChar2})
function.

The rows in the matrices of individual accuracy measures correspond to each
unique set of accuracy measures in the algorithm. Individuals with the same
set of accuracy measures are displayed together in a single row of the
matrix. The columns correspond to the pooling sensitivity, pooling
specificity, pooling positive predictive value, pooling negative predictive
value, and the indices for the individuals in each row of the matrix.
Individual accuracy measures are provided only if \kbd{individual=TRUE}.
}
\examples{
config.mat <- matrix(data = c(rep(1, 10), 1:10),
                     nrow = 2, ncol = 10, byrow = TRUE)
res1 <- opChar1(algorithm = "D2", p = 0.05, Se = 0.99, Sp = 0.99,
        hier.config = config.mat)
Accuracy(res1, individual = FALSE)
Accuracy(res1, individual = TRUE)

res2 <- opChar2(algorithm = "A2M",
                p.vec = c(0.92, 0.05, 0.02, 0.01),
                Se = rep(0.95, 2), Sp = rep(0.99, 2),
                rowcol.sz = 8)
Accuracy(res2)
}
\author{
Brianna D. Hitt
}
