% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kf_pls_state.R
\name{kf_pls_state_fit}
\alias{kf_pls_state_fit}
\title{Finalize a KF-PLS state into a fitted model}
\usage{
kf_pls_state_fit(state, tol = 1e-08)
}
\arguments{
\item{state}{External pointer created by \code{\link[=kf_pls_state_new]{kf_pls_state_new()}}.}

\item{tol}{Numeric tolerance for the inner SIMPLS step.}
}
\value{
A list with PLS factors and coefficients, classed as \code{big_plsr}.
}
\description{
Converts the accumulated KF-PLS state into a SIMPLS-equivalent fitted
model (using the current sufficient statistics). The result is compatible
with \code{\link[=predict.big_plsr]{predict.big_plsr()}}.
}
\examples{
n <- 200; p <- 30; m <- 2; A <- 3
X <- matrix(rnorm(n*p), n, p)
Y <- X[,1:2] \%*\% matrix(c(0.7, -0.3, 0.2, 0.9), 2, m) + matrix(rnorm(n*m, sd=0.2), n, m)

state <- kf_pls_state_new(p, m, A, lambda = 0.99, q_proc = 1e-6)

# stream in mini-batches
bs <- 64
for (i in seq(1, n, by = bs)) {
  idx <- i:min(i+bs-1, n)
  kf_pls_state_update(state, X[idx, , drop=FALSE], Y[idx, , drop=FALSE])
}

fit <- kf_pls_state_fit(state)  # returns a big_plsr-compatible list
# predict via your existing predict.big_plsr (linear case)
Yhat <- cbind(1, scale(X, center = fit$x_means, scale = FALSE)) \%*\%
  rbind(fit$intercept, fit$coefficients)

}
